/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config.world;

import dev.toma.configuration.client.IValidationHandler;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.gunsrpg.GunsRPG;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public final class MobHealthBuffConfig {
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Comment(value={"Chance that mobs will spawn with 2x more HP"})
    @Configurable.Gui.NumberFormat(value="#.###")
    public float health2xChance = 0.5f;
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Comment(value={"Chance that mobs will spawn with 3x more HP"})
    @Configurable.Gui.NumberFormat(value="#.###")
    public float health3xChance = 0.2f;
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Comment(value={"Chance that mobs will spawn with 4x more HP"})
    @Configurable.Gui.NumberFormat(value="#.###")
    public float health4xChance = 0.04f;
    @Configurable
    @Configurable.Comment(value={"List of entities which won't be affected by health buffs"})
    @Configurable.ValueUpdateCallback(method="onHealthBuffValidate")
    @Configurable.Gui.CharacterLimit(value=64)
    public String[] healthBuffBlacklist = new String[]{"minecraft:ender_dragon", "minecraft:wither", "minecraft:iron_golem", "gunsrpg:rocket_angel", "gunsrpg:bloodmoon_golem", "gunsrpg:gold_dragon", "gunsrpg:zombie_nightmare"};
    private final Lazy<Set<EntityType<?>>> healthBuffBlacklistedEntities = Lazy.of(() -> {
        HashSet set = new HashSet();
        this.loadHealthBuffBlacklist(set, this.healthBuffBlacklist);
        return set;
    });

    public void onHealthBuffValidate(String[] values, IValidationHandler handler) {
        Set blacklist = (Set)this.healthBuffBlacklistedEntities.get();
        blacklist.clear();
        String invalidId = this.loadHealthBuffBlacklist(blacklist, values);
        if (invalidId != null) {
            handler.setValidationResult(ValidationResult.warn((IFormattableTextComponent)new TranslationTextComponent("text.config.validation.invalid_id.entity", new Object[]{invalidId})));
        }
    }

    public boolean isHealthBuffDisabled(EntityType<?> type) {
        return ((Set)this.healthBuffBlacklistedEntities.get()).contains(type);
    }

    private String loadHealthBuffBlacklist(Collection<EntityType<?>> output, String[] entityIds) {
        String lastInvalidId = null;
        for (String entityId : entityIds) {
            ResourceLocation location = new ResourceLocation(entityId);
            if (ForgeRegistries.ENTITIES.containsKey(location)) {
                output.add((EntityType<?>)ForgeRegistries.ENTITIES.getValue(location));
                continue;
            }
            lastInvalidId = entityId;
            GunsRPG.log.warn("Found unknown entity ID '{}' in config under 'mobHealthBuffs' field", (Object)entityId);
        }
        return lastInvalidId;
    }
}

